/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LifeCycleManager;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.spi.SequenceNumberGenerator;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.ExecutorServiceUtil;
import ch.qos.logback.core.util.NetworkAddressUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

public class ContextBase
implements Context,
LifeCycle {
    private long birthTime = System.currentTimeMillis();
    private String name;
    private StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new ConcurrentHashMap<String, Object>();
    LogbackLock configurationLock = new LogbackLock();
    private ScheduledExecutorService scheduledExecutorService;
    protected List<ScheduledFuture<?>> scheduledFutures = new ArrayList(1);
    private LifeCycleManager lifeCycleManager;
    private SequenceNumberGenerator sequenceNumberGenerator;
    private boolean started;

    public ContextBase() {
        this.initCollisionMaps();
    }

    @Override
    public StatusManager getStatusManager() {
        return this.sm;
    }

    public void setStatusManager(StatusManager statusManager) {
        if (statusManager == null) {
            throw new IllegalArgumentException("null StatusManager not allowed");
        }
        this.sm = statusManager;
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    @Override
    public void putProperty(String string, String string2) {
        if ("HOSTNAME".equalsIgnoreCase(string)) {
            this.putHostnameProperty(string2);
            return;
        }
        this.propertyMap.put(string, string2);
    }

    protected void initCollisionMaps() {
        this.putObject("FA_FILENAMES_MAP", new HashMap());
        this.putObject("RFA_FILENAME_PATTERN_COLLISION_MAP", new HashMap());
    }

    @Override
    public String getProperty(String string) {
        if ("CONTEXT_NAME".equals(string)) {
            return this.getName();
        }
        if ("HOSTNAME".equalsIgnoreCase(string)) {
            return this.lazyGetHostname();
        }
        return this.propertyMap.get(string);
    }

    private String lazyGetHostname() {
        String string = this.propertyMap.get("HOSTNAME");
        if (string == null) {
            string = new NetworkAddressUtil(this).safelyGetLocalHostName();
            this.putHostnameProperty(string);
        }
        return string;
    }

    private void putHostnameProperty(String string) {
        if (this.propertyMap.get("HOSTNAME") == null) {
            this.propertyMap.put("HOSTNAME", string);
        }
    }

    @Override
    public Object getObject(String string) {
        return this.objectMap.get(string);
    }

    @Override
    public void putObject(String string, Object object) {
        this.objectMap.put(string, object);
    }

    public void removeObject(String string) {
        this.objectMap.remove(string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.stopExecutorService();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void reset() {
        this.removeShutdownHook();
        this.getLifeCycleManager().reset();
        this.propertyMap.clear();
        this.objectMap.clear();
    }

    @Override
    public void setName(String string) throws IllegalStateException {
        if (string != null && string.equals(this.name)) {
            return;
        }
        if (this.name == null || "default".equals(this.name)) {
            this.name = string;
            return;
        }
        throw new IllegalStateException("Context has been already given a name");
    }

    @Override
    public long getBirthTime() {
        return this.birthTime;
    }

    @Override
    public Object getConfigurationLock() {
        return this.configurationLock;
    }

    @Override
    public synchronized ExecutorService getExecutorService() {
        return this.getScheduledExecutorService();
    }

    @Override
    public synchronized ScheduledExecutorService getScheduledExecutorService() {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = ExecutorServiceUtil.newScheduledExecutorService();
        }
        return this.scheduledExecutorService;
    }

    private synchronized void stopExecutorService() {
        if (this.scheduledExecutorService != null) {
            ExecutorServiceUtil.shutdown(this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
    }

    private void removeShutdownHook() {
        Thread thread = (Thread)this.getObject("SHUTDOWN_HOOK");
        if (thread != null) {
            this.removeObject("SHUTDOWN_HOOK");
            try {
                this.sm.add(new InfoStatus("Removing shutdownHook ".concat(String.valueOf(thread)), this));
                boolean bl2 = Runtime.getRuntime().removeShutdownHook(thread);
                this.sm.add(new InfoStatus("ShutdownHook removal result: ".concat(String.valueOf(bl2)), this));
                return;
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    @Override
    public void register(LifeCycle lifeCycle) {
        this.getLifeCycleManager().register(lifeCycle);
    }

    synchronized LifeCycleManager getLifeCycleManager() {
        if (this.lifeCycleManager == null) {
            this.lifeCycleManager = new LifeCycleManager();
        }
        return this.lifeCycleManager;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void addScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFutures.add(scheduledFuture);
    }

    @Deprecated
    public List<ScheduledFuture<?>> getScheduledFutures() {
        return this.getCopyOfScheduledFutures();
    }

    public List<ScheduledFuture<?>> getCopyOfScheduledFutures() {
        return new ArrayList(this.scheduledFutures);
    }

    @Override
    public SequenceNumberGenerator getSequenceNumberGenerator() {
        return this.sequenceNumberGenerator;
    }

    @Override
    public void setSequenceNumberGenerator(SequenceNumberGenerator sequenceNumberGenerator) {
        this.sequenceNumberGenerator = sequenceNumberGenerator;
    }
}

