/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public class ConsoleAppender<E>
extends OutputStreamAppender<E> {
    protected ConsoleTarget target = ConsoleTarget.SystemOut;
    protected boolean withJansi = false;
    private static final String AnsiConsole_CLASS_NAME = "org.fusesource.jansi.AnsiConsole";
    private static final String wrapSystemOut_METHOD_NAME = "wrapSystemOut";
    private static final String wrapSystemErr_METHOD_NAME = "wrapSystemErr";
    private static final Class<?>[] ARGUMENT_TYPES = new Class[]{PrintStream.class};

    public void setTarget(String string) {
        ConsoleTarget consoleTarget = ConsoleTarget.findByName(string.trim());
        if (consoleTarget == null) {
            this.targetWarn(string);
            return;
        }
        this.target = consoleTarget;
    }

    public String getTarget() {
        return this.target.getName();
    }

    private void targetWarn(String object) {
        object = new WarnStatus("[" + (String)object + "] should be one of " + Arrays.toString((Object[])ConsoleTarget.values()), this);
        object.add(new WarnStatus("Using previously set target, System.out by default.", this));
        this.addStatus((Status)object);
    }

    @Override
    public void start() {
        OutputStream outputStream = this.target.getStream();
        if (this.withJansi) {
            outputStream = this.wrapWithJansi(outputStream);
        }
        this.setOutputStream(outputStream);
        super.start();
    }

    private OutputStream wrapWithJansi(OutputStream outputStream) {
        try {
            this.addInfo("Enabling JANSI AnsiPrintStream for the console.");
            Class<?> clazz = Loader.getClassLoaderOfObject(this.context).loadClass(AnsiConsole_CLASS_NAME);
            String string = this.target == ConsoleTarget.SystemOut ? wrapSystemOut_METHOD_NAME : wrapSystemErr_METHOD_NAME;
            return (OutputStream)clazz.getMethod(string, ARGUMENT_TYPES).invoke(null, new PrintStream(outputStream));
        }
        catch (Exception exception) {
            this.addWarn("Failed to create AnsiPrintStream. Falling back on the default stream.", exception);
            return outputStream;
        }
    }

    public boolean isWithJansi() {
        return this.withJansi;
    }

    public void setWithJansi(boolean bl2) {
        this.withJansi = bl2;
    }
}

