/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AsyncAppenderBase$Worker;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.util.InterruptUtil;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class AsyncAppenderBase<E>
extends UnsynchronizedAppenderBase<E>
implements AppenderAttachable<E> {
    AppenderAttachableImpl<E> aai = new AppenderAttachableImpl();
    BlockingQueue<E> blockingQueue;
    public static final int DEFAULT_QUEUE_SIZE = 256;
    int queueSize = 256;
    int appenderCount = 0;
    static final int UNDEFINED = -1;
    int discardingThreshold = -1;
    boolean neverBlock = false;
    AsyncAppenderBase$Worker worker = new AsyncAppenderBase$Worker(this);
    public static final int DEFAULT_MAX_FLUSH_TIME = 1000;
    int maxFlushTime = 1000;

    protected boolean isDiscardable(E e2) {
        return false;
    }

    protected void preprocess(E e2) {
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.appenderCount == 0) {
            this.addError("No attached appenders found.");
            return;
        }
        if (this.queueSize <= 0) {
            this.addError("Invalid queue size [" + this.queueSize + "]");
            return;
        }
        this.blockingQueue = new ArrayBlockingQueue(this.queueSize);
        if (this.discardingThreshold == -1) {
            this.discardingThreshold = this.queueSize / 5;
        }
        this.addInfo("Setting discardingThreshold to " + this.discardingThreshold);
        this.worker.setDaemon(true);
        this.worker.setName("AsyncAppender-Worker-" + this.getName());
        super.start();
        this.worker.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.worker.interrupt();
        InterruptUtil interruptUtil = new InterruptUtil(this.context);
        try {
            interruptUtil.maskInterruptFlag();
            this.worker.join(this.maxFlushTime);
            if (this.worker.isAlive()) {
                this.addWarn("Max queue flush timeout (" + this.maxFlushTime + " ms) exceeded. Approximately " + this.blockingQueue.size() + " queued events were possibly discarded.");
            } else {
                this.addInfo("Queue flush finished successfully within timeout.");
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            int n2 = this.blockingQueue.size();
            this.addError("Failed to join worker thread. " + n2 + " queued events may be discarded.", interruptedException);
            return;
        }
        finally {
            interruptUtil.unmaskInterruptFlag();
        }
    }

    @Override
    protected void append(E e2) {
        if (this.isQueueBelowDiscardingThreshold() && this.isDiscardable(e2)) {
            return;
        }
        this.preprocess(e2);
        this.put(e2);
    }

    private boolean isQueueBelowDiscardingThreshold() {
        return this.blockingQueue.remainingCapacity() < this.discardingThreshold;
    }

    private void put(E e2) {
        if (this.neverBlock) {
            this.blockingQueue.offer(e2);
            return;
        }
        this.putUninterruptibly(e2);
    }

    private void putUninterruptibly(E e2) {
        boolean bl2 = false;
        try {
            while (true) {
                try {
                    this.blockingQueue.put(e2);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    continue;
                }
                break;
            }
            if (bl2) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        catch (Throwable throwable) {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int n2) {
        this.queueSize = n2;
    }

    public int getDiscardingThreshold() {
        return this.discardingThreshold;
    }

    public void setDiscardingThreshold(int n2) {
        this.discardingThreshold = n2;
    }

    public int getMaxFlushTime() {
        return this.maxFlushTime;
    }

    public void setMaxFlushTime(int n2) {
        this.maxFlushTime = n2;
    }

    public int getNumberOfElementsInQueue() {
        return this.blockingQueue.size();
    }

    public void setNeverBlock(boolean bl2) {
        this.neverBlock = bl2;
    }

    public boolean isNeverBlock() {
        return this.neverBlock;
    }

    public int getRemainingCapacity() {
        return this.blockingQueue.remainingCapacity();
    }

    @Override
    public void addAppender(Appender<E> appender) {
        if (this.appenderCount == 0) {
            ++this.appenderCount;
            this.addInfo("Attaching appender named [" + appender.getName() + "] to AsyncAppender.");
            this.aai.addAppender(appender);
            return;
        }
        this.addWarn("One and only one appender may be attached to AsyncAppender.");
        this.addWarn("Ignoring additional appender named [" + appender.getName() + "]");
    }

    @Override
    public Iterator<Appender<E>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<E> getAppender(String string) {
        return this.aai.getAppender(string);
    }

    @Override
    public boolean isAttached(Appender<E> appender) {
        return this.aai.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<E> appender) {
        return this.aai.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String string) {
        return this.aai.detachAppender(string);
    }
}

