/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter$ReconfiguringThread;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.spi.FilterReply;
import java.net.URL;
import org.slf4j.Marker;

public class ReconfigureOnChangeFilter
extends TurboFilter {
    public static final long DEFAULT_REFRESH_PERIOD = 60000L;
    long refreshPeriod = 60000L;
    URL mainConfigurationURL;
    protected volatile long nextCheck;
    ConfigurationWatchList configurationWatchList;
    private long invocationCounter = 0L;
    private volatile long mask = 15L;
    private volatile long lastMaskCheck = System.currentTimeMillis();
    private static final int MAX_MASK = 65535;
    private static final long MASK_INCREASE_THRESHOLD = 100L;
    private static final long MASK_DECREASE_THRESHOLD = 800L;

    @Override
    public void start() {
        this.configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(this.context);
        if (this.configurationWatchList != null) {
            this.mainConfigurationURL = this.configurationWatchList.getMainURL();
            if (this.mainConfigurationURL == null) {
                this.addWarn("Due to missing top level configuration file, automatic reconfiguration is impossible.");
                return;
            }
            Object object = this.configurationWatchList.getCopyOfFileWatchList();
            long l2 = this.refreshPeriod / 1000L;
            this.addInfo("Will scan for changes in [" + object + "] every " + l2 + " seconds. ");
            object = this.configurationWatchList;
            synchronized (object) {
                this.updateNextCheck(System.currentTimeMillis());
            }
            super.start();
            return;
        }
        this.addWarn("Empty ConfigurationWatchList in context");
    }

    public String toString() {
        return "ReconfigureOnChangeFilter{invocationCounter=" + this.invocationCounter + '}';
    }

    @Override
    public FilterReply decide(Marker object, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if ((this.invocationCounter++ & this.mask) != this.mask) {
            return FilterReply.NEUTRAL;
        }
        long l2 = System.currentTimeMillis();
        object = this.configurationWatchList;
        synchronized (object) {
            this.updateMaskIfNecessary(l2);
            if (this.changeDetected(l2)) {
                this.disableSubsequentReconfiguration();
                this.detachReconfigurationToNewThread();
            }
        }
        return FilterReply.NEUTRAL;
    }

    private void updateMaskIfNecessary(long l2) {
        long l3 = l2 - this.lastMaskCheck;
        this.lastMaskCheck = l2;
        if (l3 < 100L && this.mask < 65535L) {
            this.mask = this.mask << 1 | 1L;
            return;
        }
        if (l3 > 800L) {
            this.mask >>>= 2;
        }
    }

    void detachReconfigurationToNewThread() {
        this.addInfo("Detected change in [" + this.configurationWatchList.getCopyOfFileWatchList() + "]");
        this.context.getScheduledExecutorService().submit(new ReconfigureOnChangeFilter$ReconfiguringThread(this));
    }

    void updateNextCheck(long l2) {
        this.nextCheck = l2 + this.refreshPeriod;
    }

    protected boolean changeDetected(long l2) {
        if (l2 >= this.nextCheck) {
            this.updateNextCheck(l2);
            return this.configurationWatchList.changeDetected();
        }
        return false;
    }

    void disableSubsequentReconfiguration() {
        this.nextCheck = Long.MAX_VALUE;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(long l2) {
        this.refreshPeriod = l2;
    }

    static /* synthetic */ Context access$000(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$100(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$200(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$300(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$400(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$500(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }

    static /* synthetic */ Context access$600(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
        return reconfigureOnChangeFilter.context;
    }
}

