/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

public interface ILoggingEvent
extends DeferredProcessingAware {
    public String getThreadName();

    public Level getLevel();

    public String getMessage();

    public Object[] getArgumentArray();

    public String getFormattedMessage();

    public String getLoggerName();

    public LoggerContextVO getLoggerContextVO();

    public IThrowableProxy getThrowableProxy();

    public StackTraceElement[] getCallerData();

    public boolean hasCallerData();

    default public Marker getMarker() {
        List<Marker> list = this.getMarkerList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<Marker> getMarkerList();

    public Map<String, String> getMDCPropertyMap();

    public Map<String, String> getMdc();

    public long getTimeStamp();

    default public int getNanoseconds() {
        Instant instant = this.getInstant();
        if (instant == null) {
            return 0;
        }
        return instant.getNano();
    }

    default public Instant getInstant() {
        return null;
    }

    public long getSequenceNumber();

    public List<KeyValuePair> getKeyValuePairs();

    @Override
    public void prepareForDeferredProcessing();
}

