/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.KeyValuePairConverter$ValueQuoteSpecification;
import ch.qos.logback.classic.spi.ILoggingEvent;
import org.slf4j.event.KeyValuePair;

public class KeyValuePairConverter
extends ClassicConverter {
    static final String DOUBLE_OPTION_STR = "DOUBLE";
    static final String SINGLE_OPTION_STR = "SINGLE";
    static final String NONE_OPTION_STR = "NONE";
    KeyValuePairConverter$ValueQuoteSpecification valueQuoteSpec = KeyValuePairConverter$ValueQuoteSpecification.DOUBLE;

    @Override
    public void start() {
        String string = this.getFirstOption();
        this.valueQuoteSpec = this.optionStrToSpec(string);
        super.start();
    }

    private KeyValuePairConverter$ValueQuoteSpecification optionStrToSpec(String string) {
        if (string == null) {
            return KeyValuePairConverter$ValueQuoteSpecification.DOUBLE;
        }
        if (DOUBLE_OPTION_STR.equalsIgnoreCase(string)) {
            return KeyValuePairConverter$ValueQuoteSpecification.DOUBLE;
        }
        if (SINGLE_OPTION_STR.equalsIgnoreCase(string)) {
            return KeyValuePairConverter$ValueQuoteSpecification.SINGLE;
        }
        if (NONE_OPTION_STR.equalsIgnoreCase(string)) {
            return KeyValuePairConverter$ValueQuoteSpecification.NONE;
        }
        return KeyValuePairConverter$ValueQuoteSpecification.DOUBLE;
    }

    @Override
    public String convert(ILoggingEvent object) {
        if ((object = object.getKeyValuePairs()) == null || object.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < object.size(); ++i2) {
            KeyValuePair keyValuePair = (KeyValuePair)object.get(i2);
            if (i2 != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(String.valueOf(keyValuePair.key));
            stringBuilder.append('=');
            Character c2 = this.valueQuoteSpec.asChar();
            if (c2 != null) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(String.valueOf(keyValuePair.value));
            if (c2 == null) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

