/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;

public class LoggerModelHandler
extends ModelHandlerBase {
    Logger logger;
    boolean inError = false;

    public LoggerModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new LoggerModelHandler(context);
    }

    public Class<LoggerModel> getSupportedModelClass() {
        return LoggerModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) throws ModelHandlerException {
        this.inError = false;
        model = (LoggerModel)model;
        String string = modelInterpretationContext.subst(((LoggerModel)model).getName());
        Object object = (LoggerContext)this.context;
        this.logger = ((LoggerContext)object).getLogger(string);
        object = modelInterpretationContext.subst(((LoggerModel)model).getLevel());
        if (!OptionHelper.isNullOrEmpty((String)object)) {
            if ("INHERITED".equalsIgnoreCase((String)object) || "NULL".equalsIgnoreCase((String)object)) {
                this.addInfo("Setting level of logger [" + string + "] to null, i.e. INHERITED");
                this.logger.setLevel(null);
            } else {
                object = Level.toLevel((String)object);
                this.addInfo("Setting level of logger [" + string + "] to " + object);
                this.logger.setLevel((Level)object);
            }
        }
        if (!OptionHelper.isNullOrEmpty((String)(object = modelInterpretationContext.subst(((LoggerModel)model).getAdditivity())))) {
            boolean bl2 = OptionHelper.toBoolean((String)object, true);
            this.addInfo("Setting additivity of logger [" + string + "] to " + bl2);
            this.logger.setAdditive(bl2);
        }
        modelInterpretationContext.pushObject(this.logger);
    }

    @Override
    public void postHandle(ModelInterpretationContext object, Model model) {
        if (this.inError) {
            return;
        }
        Object object2 = ((ModelInterpretationContext)object).peekObject();
        if (object2 != this.logger) {
            object = (LoggerModel)model;
            this.addWarn("The object [" + object2 + "] on the top the of the stack is not the expected logger named " + ((LoggerModel)object).getName());
            return;
        }
        ((ModelInterpretationContext)object).popObject();
    }
}

