/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.model.ContextNameModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;

public class ContextNameModelHandler
extends ModelHandlerBase {
    public ContextNameModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ContextNameModelHandler(context);
    }

    public Class<ContextNameModel> getSupportedModelClass() {
        return ContextNameModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext object, Model model) throws ModelHandlerException {
        model = (ContextNameModel)model;
        object = ((ModelInterpretationContext)object).subst(model.getBodyText());
        this.addInfo("Setting logger context name as [" + (String)object + "]");
        try {
            this.context.setName((String)object);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.addError("Failed to rename context [" + this.context.getName() + "] as [" + (String)object + "]", illegalStateException);
            return;
        }
    }
}

