/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.log4j;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.helpers.Transform;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class XMLLayout
extends LayoutBase<ILoggingEvent> {
    private final int DEFAULT_SIZE = 256;
    private final int UPPER_LIMIT = 2048;
    private StringBuilder buf = new StringBuilder(256);
    private boolean locationInfo = false;
    private boolean properties = false;

    @Override
    public void start() {
        super.start();
    }

    public void setLocationInfo(boolean bl2) {
        this.locationInfo = bl2;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setProperties(boolean bl2) {
        this.properties = bl2;
    }

    public boolean getProperties() {
        return this.properties;
    }

    @Override
    public String doLayout(ILoggingEvent iLoggingEvent) {
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuilder(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event logger=\"");
        this.buf.append(Transform.escapeTags(iLoggingEvent.getLoggerName()));
        this.buf.append("\"\r\n");
        this.buf.append("             timestamp=\"");
        this.buf.append(iLoggingEvent.getTimeStamp());
        this.buf.append("\" level=\"");
        this.buf.append(iLoggingEvent.getLevel());
        this.buf.append("\" thread=\"");
        this.buf.append(Transform.escapeTags(iLoggingEvent.getThreadName()));
        this.buf.append("\">\r\n");
        this.buf.append("  <log4j:message>");
        this.buf.append(Transform.escapeTags(iLoggingEvent.getFormattedMessage()));
        this.buf.append("</log4j:message>\r\n");
        Object object = iLoggingEvent.getThrowableProxy();
        if (object != null) {
            object = object.getStackTraceElementProxyArray();
            this.buf.append("  <log4j:throwable><![CDATA[");
            int n2 = ((Serializable[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = object[i2];
                this.buf.append('\t');
                this.buf.append(((StackTraceElementProxy)object2).toString());
                this.buf.append("\r\n");
            }
            this.buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo && (object = iLoggingEvent.getCallerData()) != null && ((Serializable[])object).length > 0) {
            object = object[0];
            this.buf.append("  <log4j:locationInfo class=\"");
            this.buf.append(((StackTraceElement)object).getClassName());
            this.buf.append("\"\r\n");
            this.buf.append("                      method=\"");
            this.buf.append(Transform.escapeTags(((StackTraceElement)object).getMethodName()));
            this.buf.append("\" file=\"");
            this.buf.append(Transform.escapeTags(((StackTraceElement)object).getFileName()));
            this.buf.append("\" line=\"");
            this.buf.append(((StackTraceElement)object).getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        if (this.getProperties() && (object = iLoggingEvent.getMDCPropertyMap()) != null && object.size() != 0) {
            object = object.entrySet();
            this.buf.append("  <log4j:properties>");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.buf.append("\r\n    <log4j:data");
                this.buf.append(" name='" + Transform.escapeTags((String)entry.getKey()) + "'");
                this.buf.append(" value='" + Transform.escapeTags((String)entry.getValue()) + "'");
                this.buf.append(" />");
            }
            this.buf.append("\r\n  </log4j:properties>");
        }
        this.buf.append("\r\n</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }
}

